﻿using System.Numerics;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;

namespace Mini_LD49
{
    class GameOverPopup
    {
        Vector2 pos;
        Vector2 textPos;
        Vector2 textPos2;
        Vector2 textPos3;
        Texture2D tex;

        Button retry;
        Button exit;

        SpriteFont font;
        Vector2 mousePos;
        Texture2D mouseTex;

        string calcOnce = "";

        public GameOverPopup(GraphicsDevice dev, SpriteFont sFont)
        {
            this.font = sFont;
            tex = Game.emptyTexture(Game.screenWidth / 2 + 10, Game.screenHeight / 2 + 20, Color.DarkGreen, dev);
            pos = new Vector2(Game.screenWidth / 2 - tex.Width / 2, Game.screenHeight / 2 - tex.Height / 2);
            mouseTex = Game.emptyTexture(3, 3, Color.Yellow, dev);

            retry = new Button(dev, relPos(new Vector2(20, tex.Height - 32)), font, "Retry", Color.Aquamarine, false);
            exit = new Button(dev, relPos(new Vector2(retry.pos.X + 75, tex.Height - 32)), font, "Exit", Color.Aquamarine, false);

            textPos = relPos(new Vector2(20, 20));
            textPos2 = relPos(new Vector2(20, 40));
            textPos3 = relPos(new Vector2(20, 64));
        }

        // Codes make life much easier.
        public byte update()
        {
            MouseState mouse = Mouse.GetState();
            this.mousePos = new Vector2(mouse.X, mouse.Y);
            bool down = (mouse.LeftButton == ButtonState.Pressed);

            if (exit.update(mousePos, down)) return 1; // You don't have to do anything when you exit...
            if (retry.update(mousePos, down)) { calcOnce = ""; return 2; }
            return 0;
        }

        public void draw(SpriteBatch sb, long score)
        {
            sb.Draw(tex, pos, Color.White);
            retry.draw(sb);
            exit.draw(sb);

            if (calcOnce == "") calcOnce = maxValue(score);

            sb.DrawString(font, "You gave the computer " + score + " bit!", textPos, Color.White);
            sb.DrawString(font, "= " + calcOnce + "!", textPos2, Color.White);
            sb.DrawString(font, message(score), textPos3, Color.Blue);
            // Mouse cursor last
            sb.Draw(mouseTex, mousePos, Color.White);
        }

        // Relative position
        public Vector2 relPos(Vector2 pos)
        {
            return new Vector2(pos.X + this.pos.X, pos.Y + this.pos.Y);
        }

        public string message(long score)
        {
            if (score >= 500) return "You are a true Notch!";
            else if (score == 400) return "THIS IS NOT AN EASTER EGG";
            else if (score >= 250) return "Is this even possible?!";
            else if (score >= 150) return "That's more than my high-score!";
            else if (score == 101) return "101 = 5!";
            else if (score >= 100) return "You did the right thing!";
            else if (score >= 75) return "Mighty.";
            else if (score >= 60) return "I KNOW THIS TEXT IS OUT OF THE BOX OKAY DON'T JUDGE ME LIKE THAT IT'S NOT FUNNY";
            else if (score >= 50) return "The computer probably gets hit with a stick right now...";
            else if (score == 45) return "DOMAIN error";
            else if (score >= 25) return "The user rages completely!";
            else if (score == 21) return "Enough bits to write \"LOL\"!";
            else if (score == 12) return "NULL";
            else if (score == 16) return "4 * 4";
            else if (score == 11) return "I hope this PC has a SSD...";
            else if (score == 10) return "Come on, 1023?";
            else if (score == 7) return "Enough for one character...";
            else if (score == 5) return "5 = 101!";
            else if (score == 1) return "Better than 0...";
            else if (score == 0) return "0 is not much.";
            else return "The computer didn't survive...";
        }
        
        // Fixed bug
        public static string maxValue(long bits)
        {
            BigInteger num = 1;
            BigInteger toReturn = 0;

            for (long i = 0; i < bits; i++)
            {
                toReturn += num;
                num *= 2;
            }
            return toReturn.ToString();
        }
    }

    class Button
    {
        public Texture2D tex;
        public Color color;
        public Vector2 pos;
        public Vector2 textPos;
        public SpriteFont font;
        public string text;

        private Color clr;
        private KeyPressed button = new KeyPressed(); // Mouse gets heavily discrimated here


        public Button(GraphicsDevice dev, Vector2 position, SpriteFont sFont, string s, Color clr, bool autoCenter = true, int size = -1)
        {
            if (size < 0) this.tex = Game.emptyTexture(15 * s.Length + 14, 22, clr, dev);
            else this.tex = Game.emptyTexture(size, 22, clr, dev);

            if (autoCenter) this.pos = new Vector2(position.X - tex.Width / 2, position.Y); // Auto-Center
            else this.pos = position;

            this.font = sFont;
            this.text = s;
            this.color = clr;
            this.clr = clr;
            this.textPos = new Vector2(pos.X + tex.Width / 4 - 7, pos.Y);
        }

        public bool update(Vector2 mousePos, bool isDown)
        {
            // Mouse is in button
            if (mousePos.X >= pos.X && mousePos.X <= pos.X + tex.Width && mousePos.Y >= pos.Y && mousePos.Y <= pos.Y + tex.Height)
            {
                // Leftmousebutton is down
                if (isDown) clr = decreaseAllChannels(color, 101);
                else clr = decreaseAllChannels(color, 50); // is not

                return button.pressed(isDown);
            }
            else
            {
                clr = color;
                button.pressed(false); // Reset it
            }
            return false;
        }

        public void draw(SpriteBatch sb)
        {
            sb.Draw(tex, pos, clr);
            sb.DrawString(font, text, textPos, Color.White);
        }

        // Not fail-proof!
        public static Color decreaseAllChannels(Color clr, int howMuch)
        {
            clr.R -= (byte)howMuch;
            clr.G -= (byte)howMuch;
            clr.B -= (byte)howMuch;
            return clr;
        }
    }
}
