using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;

namespace Mini_LD49
{
    public class Game : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        BitSystem sys;
        GameOverPopup failPopup;
        SpriteFont font;

        Texture2D overclock;
        Vector2 overclockPos;

        public const int screenWidth = 700;
        public const int screenHeight = 238;
        public const bool hack = false;

        bool menu = false;

        public Game()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }

        protected override void Initialize()
        {
            graphics.PreferredBackBufferWidth = screenWidth;
            graphics.PreferredBackBufferHeight = screenHeight;
            graphics.ApplyChanges();


            base.Initialize();
        }

        protected override void LoadContent()
        {
            spriteBatch = new SpriteBatch(GraphicsDevice);

            sys = new BitSystem(Content.Load<Texture2D>("textures\\bit"),
                emptyTexture(screenWidth, 100, new Color(110, 127, 158), GraphicsDevice),
                Content.Load<Texture2D>("textures\\laser"), 
                emptyTexture(42, 100, Color.DimGray, GraphicsDevice),
                Content.Load<SoundEffect>("sound\\error"),
                Content.Load<SoundEffect>("sound\\okay"));

            font = Content.Load<SpriteFont>("font");
            overclock = Content.Load<Texture2D>("textures\\overclocky");

            overclockPos = new Vector2(screenWidth / 2 - overclock.Width / 2, 0);

            failPopup = new GameOverPopup(GraphicsDevice, font);
        }

        protected override void Update(GameTime gameTime)
        {
            if (menu)
            {
                byte code = failPopup.update();
                if (code == 2)
                {
                    menu = false;
                    sys.init();
                }
                else if (code == 1)
                {
                    sys.dispose();
                    this.Exit();
                }

                sys.updateBackground();
            }
            else
            {
                sys.update();
                if (sys.gameOver && !hack) menu = true;
            }

            

            base.Update(gameTime);
        }

        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(sys.background);

            spriteBatch.Begin();
            sys.draw(spriteBatch);

            spriteBatch.Draw(overclock, overclockPos, Color.White);
            spriteBatch.DrawString(font, "Score: " + sys.score, new Vector2(20, 20), Color.White);
            
            if (menu) failPopup.draw(spriteBatch, sys.score);
            
            spriteBatch.End();

            base.Draw(gameTime);
        }

        public static Texture2D emptyTexture(int width, int height, Color color, GraphicsDevice dev)
        {
            Texture2D tex = new Texture2D(dev, width, height);
            Color[] clr = new Color[width * height];
            for (int i = 0; i < clr.Length; i++) clr[i] = color;
            tex.SetData(clr);
            return tex;
        }
    }

    class KeyPressed
    {
        public Keys key;
        private bool keyPressed = false;

        public KeyPressed(Keys key = Keys.A)
        {
            this.key = key;
        }

        public bool pressed(bool what)
        {
            if (what) { keyPressed = true; return false; }
            if (keyPressed && !what) { keyPressed = false; return true; } // reset and return true

            return false;
        }
    }
}
