﻿using System;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;

namespace Mini_LD49
{
    class BitSystem
    {   
        public static float speed = 3f;

        public long score = 0; // Long!
        public byte mistakes = 0; // Byte!
        public bool gameOver = false; // Bool!
        // Longbytebool!

        public SoundEffect error;
        public SoundEffectInstance okay;

        public Texture2D bitTex;
        public Texture2D dvdTex;
        public Texture2D laserTex;
        public Texture2D laserMetalTex;

        public Vector2 laserPos = new Vector2(Game.screenWidth / 2 - 32, 138);
        public Vector2 laserMetalPos;
        public Vector2 pos = new Vector2(0, 138);

        public Color background = new Color(0, 0, 0);

        public Bit[] bits;
        public Vector2[] bitPos;

        Random ran = new Random();
        Color defInitColor = Color.Red;
        Color wonColor = Color.Lime;


        KeyPressed up = new KeyPressed(Keys.Up);
        KeyPressed down = new KeyPressed(Keys.Down);
        byte currentPos = 0;



        public BitSystem(Texture2D defBitTex, Texture2D dvd, Texture2D laser, Texture2D metal, SoundEffect err, SoundEffect k)
        {
            this.bitTex = defBitTex;
            this.dvdTex = dvd;
            this.laserTex = laser;
            this.laserMetalTex = metal;
            
            laserMetalPos = new Vector2(laserPos.X - (metal.Width / 2 - laser.Width / 2), laserPos.Y);

            bitPos = new Vector2[] { new Vector2(laserPos.X, pos.Y), new Vector2(laserPos.X, pos.Y + laserTex.Height), new Vector2(laserPos.X, pos.Y + laserTex.Height * 2),
                new Vector2(pos.X - bitTex.Width, pos.Y + laserTex.Height / 2 - bitTex.Height / 2),
                new Vector2(pos.X - bitTex.Width, pos.Y + laserTex.Height + laserTex.Height / 2 - bitTex.Height / 2),
                new Vector2(pos.X - bitTex.Width, pos.Y + laserTex.Height * 2 + laserTex.Height / 2 - bitTex.Height / 2) };

            this.error = err;
            this.okay = k.CreateInstance();

            init();
        }

        public void init()
        {
            bits = new Bit[7];
            currentPos = 0;
            laserPos = bitPos[currentPos];
            score = 0;
            mistakes = 0;
            gameOver = false;
            speed = 2;

            for (int i = 0; i < bits.Length; i++)
            {
                bits[i] = new Bit(bitTex, new Vector2(-((i) * bitTex.Width * 4 + bitTex.Width), bitPos[ran.Next(3, 6)].Y), defInitColor);
                ran = new Random(ran.Next(int.MaxValue));
            }
        }

        public void newBit(int where)
        {
            bits[where] = new Bit(bitTex, bitPos[ran.Next(3, 6)], defInitColor);
            ran = new Random(ran.Next(int.MaxValue));
        }

        public void update()
        {
            KeyboardState state = Keyboard.GetState();

            if (state.IsKeyDown(Keys.Escape))
            {
                dispose();
                Environment.Exit(0);
            }

            updateBackground();

            if (up.pressed(state.IsKeyDown(up.key)) && currentPos > 0)
            {
                currentPos--;
                laserPos = bitPos[currentPos];
            }
            else if (down.pressed(state.IsKeyDown(down.key)) && currentPos < 2) // Got really lazy here...
            {
                currentPos++;
                laserPos = bitPos[currentPos];
            }

            for (int i = 0; i < bits.Length; i++)
            {
                bits[i].update();

                if (bits[i].done)
                {
                    if (bits[i].pos.X - bits[i].tex.Width > Game.screenWidth) newBit(i);
                }
                else if (bits[i].pos.X + bits[i].tex.Width > laserPos.X)
                {
                    if (bits[i].pos.X - bits[i].tex.Width > Game.screenWidth)
                    {
                        mistakes++;
                        error.Play();
                        if (mistakes >= 3) gameOver = true;
                        background.R = 255;
                        newBit(i);
                    }
                    else if (bits[i].pos.X < laserPos.X + laserTex.Width && bits[i].pos.Y < laserPos.Y + laserTex.Height && bits[i].pos.Y + bits[i].tex.Height > laserPos.Y)
                    {
                        okay.Pitch = (float)(ran.Next(-100, 101)) / 100;
                        ran = new Random(ran.Next(int.MaxValue));
                        okay.Play();
                        bits[i].hit(wonColor);
                        score++;
                    }
                }
            }

            speed = (float)(20 + score / 3) / 10;
        }

        public void dispose()
        {
            // Anti-laggy method to terminate the program
            okay.Stop();
            okay.Dispose();
            error.Dispose();
        }

        public void updateBackground()
        {
            if (background.R > 0) background.R -= 3;
        }

        public void draw(SpriteBatch sb)
        {
            sb.Draw(dvdTex, pos, Color.White);
            sb.Draw(laserMetalTex, laserMetalPos, Color.White);
            sb.Draw(laserTex, laserPos, Color.White);
            for (int i = 0; i < bits.Length; i++)
            {
                bits[i].draw(sb);
            }
        }
    }
}
