﻿using System;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace LD28_OneWall
{
    class WaveSystem
    {
        // WHERE DO I START?
        public int wave = 0;
        public int nullCount = 0;
        public int spawnArea;
        public int money = 0;
        public Thing[] enemy = new Enemy[0];
        public Thing[] building;

        public Texture2D e1;
        public Texture2D e2;

        public WaveSystem(int ground)
        {
            this.spawnArea = ground;
            //nextwave();
        }

        public void nextwave()
        {
            Random rand = new Random(Guid.NewGuid().GetHashCode());
            enemy = new Enemy[wave * 10 + wave * wave];
            int numberOfCars = enemy.Length / 15;
            int b = 0;
            for (int i = 0; i < enemy.Length; i++)
            {
                Random ran = new Random(i*3 + rand.Next(34, 34506));
                Vector2 pos = Vector2.Zero;
                if (wave > 4 && b == numberOfCars)
                {
                    pos = new Vector2((-i * 101) - ran.Next(100, 100 * i), Game.screenHeight - ran.Next(30, spawnArea - 30) - e2.Height);
                    enemy[i] = new Enemy(e2, EnemyType.Car);
                    b = 0;
                }
                else
                {
                    pos = new Vector2((-i * 21) - ran.Next(100, 326) - 100, Game.screenHeight - ran.Next(10, spawnArea - 10) - e1.Height);
                    enemy[i] = new Enemy(e1);
                }
                enemy[i].pos = pos;
                b++;
            }

            wave++;
        }

        public bool update(GameTime gt)
        {
            this.money = 0;
            nullCount = 0;
            for (int i = 0; i < enemy.Length; i++)
            {
                if (enemy[i] == null) { nullCount++; continue; }
                Enemy e = (Enemy)enemy[i];
                this.building = e.update(building, gt);

                if (e.pos.X > Game.screenWidth + e.tex.Width) return true;

                if (e.dead)
                {
                    if (!e.naturalDead) money += e.getMoneyFromDead;
                    enemy[i] = null; // DEAD HERE
                }
                else enemy[i] = e;
            }

            if (nullCount >= enemy.Length) nextwave();

            for (int i = 0; i < building.Length; i++)
            {
                if (building[i] == null) continue;
                Building b = (Building)building[i];

                if (b.broken)
                {
                    b = null; // WHEN BUILDING BREAKS CODE HERE!
                }
                building[i] = b;
            }
            return false;
        }

        // INCLUDE BUILDINGS HERE!!!! DO NOT DRAW THEM IN MAIN GAME CLASS
        public void draw(SpriteBatch sb)
        {
            foreach (Enemy e in enemy)
            {
                if (e == null) continue;
                e.draw(sb);
            }

            foreach (Building b in building)
            {
                if (b == null) continue;
                b.draw(sb);
            }
        }
    }
}
