﻿using System;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Input;

namespace LD28_OneWall
{
    class Player : Thing
    {
        public Random ran;
        public Color clr;
        public Texture2D bulTex;
        public bool special = false;
        int spawnplace;
        public int bInterval = 100;
        float interval = 0f;

        Bullet[] bullets = new Bullet[1];
        public Thing[] enemy;

        public Player(int spawnPlace, Texture2D texture, Texture2D bulletTexture, Thing[] enemys = null)
        {
            this.ran = new Random(Guid.NewGuid().GetHashCode());

            this.bulTex = bulletTexture;
            this.tex = texture;
            this.spawnplace = Game.screenHeight - spawnPlace;
            this.pos = new Vector2(Game.screenWidth - ran.Next(100, 190), Game.screenHeight - ran.Next(10, spawnPlace - 10) - tex.Height);
            this.enemy = enemys;
            this.clr = new Color(ran.Next(100, 255), ran.Next(100, 255), ran.Next(100, 255));
        }

        public void makeThisGuySuperSpecialAndAwesomePlease()
        {
            this.special = true;
            bInterval = 500 - ran.Next(0, 53);
        }

        public void upgrade(int howMuch)
        {
            bInterval -= howMuch;
        }

        public void update(GameTime gt)
        {
            MouseState mouse = Mouse.GetState();
            KeyboardState state = Keyboard.GetState();
            interval += (float)gt.ElapsedGameTime.Milliseconds;

            if (!special)
            {
                if (state.IsKeyDown(Keys.W) && pos.Y >= spawnplace + 10 - tex.Height) this.pos.Y -= 2;
                else if (state.IsKeyDown(Keys.S) && pos.Y <= Game.screenHeight - 10 - tex.Height) this.pos.Y += 2;
            }

            if (interval > bInterval && mouse.LeftButton == ButtonState.Pressed)
            {
                Vector2 mousePos = new Vector2(mouse.X, mouse.Y);
                Array.Resize(ref bullets, bullets.Length + 1);

                for (int i = 0; i < bullets.Length; i++)
                {
                    if (bullets[i] == null)
                    {
                        bullets[i] = new Bullet(new Vector2(pos.X - 2, pos.Y + 22), mousePos, bulTex, enemy); // ENEMYS HERE
                        if (special) { bullets[i].wonderFull = true; bullets[i].damage = 50; } // SUPER STRONG BULLETS
                        if (bullets[i].stopDoingThatYouMoran) this.enemy = bullets[i].targets;
                    }
                }
                interval = 0f;
            }

            for (int i = 0; i < bullets.Length; i++)
            {
                if (bullets[i] == null) continue;
                bullets[i].update(gt);
                if (bullets[i].stop) bullets[i] = null;
            }
        }

        public void draw(SpriteBatch sb)
        {
            foreach (Bullet b in bullets)
            {
                if (b == null) continue;
                b.draw(sb);
            }
            if (special) sb.Draw(tex, pos, clr);
            else sb.Draw(tex, pos, Color.SaddleBrown);
        }
    }
}
