/* 
                                                                                                                                                                         
                                                                                                                                                                         
   SSSSSSSSSSSSSSS UUUUUUUU     UUUUUUUU       CCCCCCCCCCCCCHHHHHHHHH     HHHHHHHHH             CCCCCCCCCCCCC     OOOOOOOOO     DDDDDDDDDDDDD      EEEEEEEEEEEEEEEEEEEEEE
 SS:::::::::::::::SU::::::U     U::::::U    CCC::::::::::::CH:::::::H     H:::::::H          CCC::::::::::::C   OO:::::::::OO   D::::::::::::DDD   E::::::::::::::::::::E
S:::::SSSSSS::::::SU::::::U     U::::::U  CC:::::::::::::::CH:::::::H     H:::::::H        CC:::::::::::::::C OO:::::::::::::OO D:::::::::::::::DD E::::::::::::::::::::E
S:::::S     SSSSSSSUU:::::U     U:::::UU C:::::CCCCCCCC::::CHH::::::H     H::::::HH       C:::::CCCCCCCC::::CO:::::::OOO:::::::ODDD:::::DDDDD:::::DEE::::::EEEEEEEEE::::E
S:::::S             U:::::U     U:::::U C:::::C       CCCCCC  H:::::H     H:::::H        C:::::C       CCCCCCO::::::O   O::::::O  D:::::D    D:::::D E:::::E       EEEEEE
S:::::S             U:::::D     D:::::UC:::::C                H:::::H     H:::::H       C:::::C              O:::::O     O:::::O  D:::::D     D:::::DE:::::E             
 S::::SSSS          U:::::D     D:::::UC:::::C                H::::::HHHHH::::::H       C:::::C              O:::::O     O:::::O  D:::::D     D:::::DE::::::EEEEEEEEEE   
  SS::::::SSSSS     U:::::D     D:::::UC:::::C                H:::::::::::::::::H       C:::::C              O:::::O     O:::::O  D:::::D     D:::::DE:::::::::::::::E   
    SSS::::::::SS   U:::::D     D:::::UC:::::C                H:::::::::::::::::H       C:::::C              O:::::O     O:::::O  D:::::D     D:::::DE:::::::::::::::E   
       SSSSSS::::S  U:::::D     D:::::UC:::::C                H::::::HHHHH::::::H       C:::::C              O:::::O     O:::::O  D:::::D     D:::::DE::::::EEEEEEEEEE   
            S:::::S U:::::D     D:::::UC:::::C                H:::::H     H:::::H       C:::::C              O:::::O     O:::::O  D:::::D     D:::::DE:::::E             
            S:::::S U::::::U   U::::::U C:::::C       CCCCCC  H:::::H     H:::::H        C:::::C       CCCCCCO::::::O   O::::::O  D:::::D    D:::::D E:::::E       EEEEEE
SSSSSSS     S:::::S U:::::::UUU:::::::U  C:::::CCCCCCCC::::CHH::::::H     H::::::HH       C:::::CCCCCCCC::::CO:::::::OOO:::::::ODDD:::::DDDDD:::::DEE::::::EEEEEEEE:::::E
S::::::SSSSSS:::::S  UU:::::::::::::UU    CC:::::::::::::::CH:::::::H     H:::::::H        CC:::::::::::::::C OO:::::::::::::OO D:::::::::::::::DD E::::::::::::::::::::E
S:::::::::::::::SS     UU:::::::::UU        CCC::::::::::::CH:::::::H     H:::::::H          CCC::::::::::::C   OO:::::::::OO   D::::::::::::DDD   E::::::::::::::::::::E
 SSSSSSSSSSSSSSS         UUUUUUUUU             CCCCCCCCCCCCCHHHHHHHHH     HHHHHHHHH             CCCCCCCCCCCCC     OOOOOOOOO     DDDDDDDDDDDDD      EEEEEEEEEEEEEEEEEEEEEE
                                                                                                                                                                         
*/

using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

namespace LD28_OneWall
{
    public enum GS
    {
        Playing,
        Buying,
        Choosing_Wall,
        Lost
    }

    public class Game : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;
        SpriteFont font;

        public static int startMoney = 0;
        public static int wallHealth = 250;
        public static int baseHealth = 1000;
        public static int screenWidth = 1024;
        public static int screenHeight = 640;


        public int money = startMoney;
        private int ground;

        // Textures and Positions
        Vector2 mousePos;
        Vector2 groundPos;
        Vector2 wallPos;
        Texture2D groundTex;
        Texture2D chTex;
        Texture2D guyTex;
        Texture2D badGuy1Tex;
        Texture2D bulletTex;
        Texture2D specialBulletTex;
        Texture2D wallTex;
        Texture2D b1Tex;
        Texture2D fenceTex;
        Texture2D badCarTex;

        BuyMenu bm;
        Player player;
        Button storeButton;
        Building wall;
        Thing[] buildings;
        Player[] guys = new Player[] { };

        WaveSystem wsys;

        Color wallColor;

        GS gamestate = GS.Choosing_Wall;

        public Game()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }

        protected override void Initialize()
        {
            graphics.PreferredBackBufferWidth = screenWidth;
            graphics.PreferredBackBufferHeight = screenHeight;
            graphics.ApplyChanges();


            base.Initialize();
        }


        protected override void LoadContent()
        {
            Random ran = new Random();
            spriteBatch = new SpriteBatch(GraphicsDevice);

            groundTex = Content.Load<Texture2D>("ground");
            chTex = Content.Load<Texture2D>("ch");
            guyTex = Content.Load<Texture2D>("guy");
            badGuy1Tex = Content.Load<Texture2D>("badguy1");
            badCarTex = Content.Load<Texture2D>("car");
            wallTex = Content.Load<Texture2D>("wall");
            font = Content.Load<SpriteFont>("font");
            b1Tex = Content.Load<Texture2D>("base1");
            fenceTex = Content.Load<Texture2D>("fence");

            bulletTex = emptyTex(10, 4, Color.Black, GraphicsDevice);
            specialBulletTex = emptyTex(10, 4, Color.White, GraphicsDevice);
            storeButton = new Button(new Vector2(screenWidth - 88, 10), GraphicsDevice, font, "Store", "DOES IT WORK?", false);
            bm = new BuyMenu(GraphicsDevice, font, b1Tex, guyTex);
            

            ground = groundTex.Height;
            groundPos = new Vector2(0, screenHeight - groundTex.Height);
            player = new Player(ground, guyTex, bulletTex);
            player.pos = new Vector2(screenWidth - 208, player.pos.Y);
        }

 
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        protected override void Update(GameTime gameTime)
        {
            KeyboardState keyboard = Keyboard.GetState();
            MouseState mouse = Mouse.GetState();
            this.mousePos = new Vector2(mouse.X, mouse.Y);

            if (keyboard.IsKeyDown(Keys.Escape)) this.Exit(); // Close when pressing escape

            if (gamestate == GS.Playing)
            {
                player.enemy = wsys.enemy;
                player.update(gameTime);
                wsys.enemy = player.enemy;
                
                for (int yay = 0; yay < guys.Length; yay++)
                {
                    guys[yay].enemy = wsys.enemy;
                    guys[yay].update(gameTime);
                    wsys.enemy = guys[yay].enemy;
                }

                if (wsys.update(gameTime))
                {
                    gamestate = GS.Lost; // YOU LOST! :((((((((
                    return;
                }
                this.buildings = wsys.building;

                bool goToBuy = storeButton.isClicked();
                if (goToBuy) { gamestate = GS.Buying; }

                money += wsys.money;
            }
            else if (gamestate == GS.Buying)
            {
                wsys.building = buildings;
                if (bm.update(this.money)) gamestate = GS.Playing;
                
                // PURCHASE BASSSEEE
                if (bm.hasBoughtBase && this.money == bm.money + BuyMenu.basePrize)
                {
                    Random ran = new Random(Guid.NewGuid().GetHashCode());
                    Building bas = new Building();
                    Building fence = new Building();

                    bas.tex = b1Tex;

                    bas.pos = new Vector2(screenWidth - bas.tex.Width - 15, screenHeight - bas.tex.Height - ran.Next(1, ground - 10));
                    bas.health = 100;

                    fence.tex = fenceTex;
                    fence.pos = new Vector2(screenWidth - 210, screenHeight - fenceTex.Height);
                    fence.health = baseHealth;


                    Thing[] temp = new Thing[buildings.Length + 2];
                    for (int i = 0; i < temp.Length; i++)
                    {
                        if (i == buildings.Length)
                        {
                            temp[i] = bas;
                            continue;
                        }
                        else if (i > buildings.Length)
                        {
                            temp[i] = fence;
                            break;
                        }
                        temp[i] = buildings[i];
                    }
                    this.buildings = temp;
                    this.wsys.building = this.buildings;
                }

                // BUYYY GUYYYY
                if (bm.hasBoughtGuy && this.money == bm.money + BuyMenu.guyPrize)
                {
                    Player p = new Player(ground, guyTex, specialBulletTex);
                    p.makeThisGuySuperSpecialAndAwesomePlease(); // He is soooo special!

                    Array.Resize(ref guys, guys.Length + 1);
                    guys[guys.Length - 1] = p;
                }

                if (bm.hasBoughtUpGuy && this.money == bm.money + BuyMenu.upgradeGuyPrize)
                {
                    for (int i = 0; i < guys.Length; i++)
                    {
                        guys[i].upgrade(200); // BALANCE
                    }
                }

                this.money = bm.money;
            }
            else if (gamestate == GS.Choosing_Wall)
            {
                if (canPlaceWallHere(mouse.X))
                {
                    wallColor = new Color(255, 255, 255, 100);
                    if (mouse.LeftButton == ButtonState.Pressed)
                    {
                        // INIT BUILDINGS HERE
                        wallPos = new Vector2(mousePos.X, screenHeight - wallTex.Height - 5);
                        wall = new Building();
                        wall.pos = wallPos;
                        wall.tex = wallTex;
                        wall.health = wallHealth;

                        buildings = new Thing[] { wall };
                        wsys = new WaveSystem(ground);
                        wsys.building = buildings;
                        wsys.e1 = badGuy1Tex;
                        wsys.e2 = badCarTex;
                        wsys.nextwave();

                        gamestate = GS.Playing;
                    }
                }
                else wallColor = new Color(255, 100, 100, 100);
            }

            base.Update(gameTime);
        }

        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.CornflowerBlue);

            spriteBatch.Begin();
            spriteBatch.Draw(groundTex, groundPos, Color.White);
            storeButton.draw(spriteBatch);
            

            if (gamestate == GS.Playing) 
            {
                wsys.draw(spriteBatch);
                foreach (Player guy in guys)
                {
                    guy.draw(spriteBatch);
                }
                player.draw(spriteBatch);
            }
            else if (gamestate == GS.Buying)
            {
                wsys.draw(spriteBatch);
                foreach (Player guy in guys)
                {
                    guy.draw(spriteBatch);
                }
                player.draw(spriteBatch);
                bm.draw(spriteBatch);
            }
            else if (gamestate == GS.Choosing_Wall)
            {
                spriteBatch.Draw(wallTex, new Vector2(mousePos.X, screenHeight - wallTex.Height - 5), wallColor);
                foreach (Player guy in guys)
                {
                    guy.draw(spriteBatch);
                }
                player.draw(spriteBatch);
            }
            else if (gamestate == GS.Lost)
            {
                spriteBatch.DrawString(font, "You lost!", new Vector2(300, 250), Color.Red, 0.0f, Vector2.Zero, 4f, SpriteEffects.None, 0);
            }

            spriteBatch.DrawString(font, "Money: " + this.money, new Vector2(20, 20), Color.White);
            spriteBatch.Draw(chTex, new Vector2(mousePos.X - chTex.Width / 2, mousePos.Y - chTex.Height / 2), Color.White); // Draw crosshair
            spriteBatch.End();
            
            base.Draw(gameTime);
        }

        //canplacewallhere LAWL ALMOST USELESS
        public static bool canPlaceWallHere(int x)
        {
            return (x > 200 && x < screenHeight);
        }

        // IS HIT!
        public static int isHit(Thing[] enemy, Vector2 pos, int texWidth, int texHeight)
        {
            if (enemy == null) return -1;
            if (pos.X >= screenWidth + texWidth) return -1;
            if (pos.Y >= screenHeight + texHeight) return -1;
            if (pos.Y <= screenHeight - 269 - 64) return -1; // THIS IS NOT DYNAMIC, NOT DYNAMIC NOT DYNAMAMMIIICICICCCC
            //Rectangle rect = new Rectangle((int)pos.X, (int)pos.Y, texWidth, texHeight);
            

            for (int i = 0; i < enemy.Length; i++)
            {
                if (enemy[i] == null) continue;
                if (enemy[i].pos.X <= -32) continue;
                //Rectangle tRect = new Rectangle((int)enemy[i].pos.X, (int)enemy[i].pos.Y, enemy[i].tex.Width, enemy[i].tex.Height);
                //if (rect.Intersects(tRect)) return i;
                if (pos.X - texWidth > enemy[i].pos.X && pos.X < enemy[i].pos.X + enemy[i].tex.Width &&
                    pos.Y - texHeight > enemy[i].pos.Y && pos.Y < enemy[i].pos.Y + enemy[i].tex.Height) return i;
            }
            return -1;
        }

        // AGAIN USELESS FOR NOW
        public static Vector2 tileCollision(Thing[] tiles, Vector2 pos, Vector2 velocity, int texWidth, int texHeight)
        {
            if (pos.X < 200) return velocity;
            Vector2 lowestVelocity = velocity;
            for (int i = 0; i < tiles.Length; i++)
            {
                Vector2 vel = collision(tiles[i].pos, tiles[i].tex.Width, tiles[i].tex.Height, pos, velocity, texWidth, texHeight);
                if (vel.X < lowestVelocity.X) lowestVelocity.X = vel.X;
                if (vel.Y < lowestVelocity.Y) lowestVelocity.Y = vel.Y;
            }
            return lowestVelocity;
        }

        //calculates velocity
        public static Vector2 collision(Vector2 target, int targetTexWidth, int targetTexHeight, Vector2 pos, Vector2 velocity, int texWidth, int texHeight)
        {
            /*Vector2 tPos = pos + velocity;
            Rectangle rect = new Rectangle((int)tPos.X, (int)tPos.Y, texWidth, texHeight);
            Rectangle targetRect = new Rectangle((int)target.X, (int)target.Y, targetTexWidth, targetTexHeight);

            if (!targetRect.Intersects(rect)) return velocity;
            float y = velocity.Y;
            float x = velocity.X;
            bool undoX = false;
            bool undoY = false;

            while (targetRect.Intersects(rect))
            {
                if ((int)velocity.X == 0)
                {
                    if ((int)x != 0) undoX = true;
                    break;
                }

                if (velocity.X > 0)
                {
                    velocity.X--;
                }
                else if (velocity.X < 0)
                {
                    velocity.X++;
                }

                tPos = pos + velocity;
                rect = new Rectangle((int)tPos.X, (int)tPos.Y, texWidth, texHeight);
            }
            if (undoX) velocity.X = x;

            while (targetRect.Intersects(rect))
            {
                if ((int)velocity.Y == 0)
                {
                    if ((int)y != 0) undoY = true;
                    break;
                }

                if (velocity.Y > 0)
                {
                    velocity.Y--;
                }
                else if (velocity.Y < 0)
                {
                    velocity.Y++;
                }

                tPos = pos + velocity;
                rect = new Rectangle((int)tPos.X, (int)tPos.Y, texWidth, texHeight);
            }
            if (undoY) velocity.Y = y;

            return velocity;*/
            Vector2 tPos = pos + velocity;
            Rectangle rect = new Rectangle((int)tPos.X, (int)tPos.Y, texWidth, texHeight);
            Rectangle targetRect = new Rectangle((int)target.X, (int)target.Y, targetTexWidth, targetTexHeight);
            if (rect.Intersects(targetRect)) return Vector2.Zero;
            return velocity;
        }

        //Creates a new texture! MAKE IS USELESS
        public static Texture2D emptyTex(int width, int height, Color color, GraphicsDevice dev, bool make = true)
        {
            Texture2D tex = new Texture2D(dev, width, height);
            if (make)
            {
                Color[] clr = new Color[width * height];
                for (int i = 0; i < clr.Length; i++) clr[i] = color;
                tex.SetData(clr);
            }
            return tex;
        }
    }
}
