﻿using System;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;


namespace LD28_OneWall
{
    public enum EnemyType // MORE TO COME LATER
    {
        Normal,
        Car
    }

    public class Enemy : Thing
    {
        public EnemyType et;
        public int reqTime = 0;
        public int health = 100;
        public bool dead = false;
        public bool naturalDead = false;
        double time = 500;
        public int getMoneyFromDead = 10;
        int damage = 10;
        int thinggy = 255;
        int vel = 1;
        Color clr = Color.White; // TRAPPED ERROR LOL

        public Enemy(Texture2D texture, EnemyType em = EnemyType.Normal)
        {
            this.tex = texture;
            this.et = em;
            getPropertiesByET(em);
        }

        public void getPropertiesByET(EnemyType et)
        {
            switch (et)
            {
                case EnemyType.Car:
                    this.vel = 5;
                    this.damage = 500;
                    this.time = 1; // Doesn't need time, explodes
                    this.reqTime = 0;
                    this.getMoneyFromDead = 50;
                    this.health = 70;
                    break;
                default:
                    this.vel = 1;
                    this.damage = 11;
                    this.time = 500;
                    this.reqTime = 500;
                    this.getMoneyFromDead = 10;
                    this.health = 250;
                    break;
            }
        }

        public Thing[] update(Thing[] buildings, GameTime gt)
        {
            if (et == EnemyType.Normal)
            {
                if (thinggy < 255)
                {
                    thinggy += 4;
                    clr = new Color(255, thinggy, thinggy);
                }
            }

            time += gt.ElapsedGameTime.Milliseconds;
            Vector2 velocity = new Vector2(vel, 0);
            int width = tex.Width;
            int height = tex.Height;
            if (et == EnemyType.Car)
            {
                width = (tex.Width * 15) / 10;
                height = (tex.Width * 15) / 10;
            }
            for (int i = 0; i < buildings.Length; i++)
            {
                if (buildings[i] == null) continue;
                Vector2 velo = Game.collision(buildings[i].pos, buildings[i].tex.Width, buildings[i].tex.Height, pos, velocity, width, height);
                if (velo.X != vel)
                {
                    if (time >= reqTime)
                    {
                        Building b = (Building)buildings[i];
                        b.attack(damage);
                        buildings[i] = b;
                        time = 0.0;
                        if (et == EnemyType.Car)
                        {
                            this.dead = true;
                            this.naturalDead = true;
                            return buildings;
                        }
                    }
                    velocity = velo;
                    break;
                }
                /*Rectangle rect1 = new Rectangle((int)pos.X, (int)pos.Y, tex.Width, tex.Height);
                Rectangle rect2 = new Rectangle((int)buildings[i].pos.X, (int)buildings[i].pos.Y, buildings[i].tex.Width, buildings[i].tex.Height);
                if (rect1.Intersects(rect2))
                {
                    velocity = Vector2.Zero;
                }*/
            }
            pos += velocity;
            return buildings;
        }

        public void doDamage(int dmg)
        {
            health -= dmg;
            if (health <= 0) { dead = true; return; };
            if (et == EnemyType.Normal)
            {
                thinggy = 20;
                clr = new Color(255, thinggy, thinggy);
            }
        }

        public void draw(SpriteBatch sb)
        {
            if (et == EnemyType.Normal) sb.Draw(tex, pos, clr);
            else sb.Draw(tex, pos, null, Color.White, 0.0f, Vector2.Zero, 1.5f, SpriteEffects.None, 0);
        }
    }

    // F**K ARRAYS
    public class Thing {
        public Texture2D tex;
        public Vector2 pos;
    }
}
