﻿using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace LD28_OneWall
{
    class BuyMenu
    {
        public static int guyPrize = 3000;
        public static int basePrize = 1500;
        public static int upgradeGuyPrize = 2500;

        public GraphicsDevice dev;
        public int money;
        public bool hasBoughtBase = false;
        public bool hasBoughtGuy = false;
        public bool hasBoughtUpGuy = false;
        public SpriteFont font;

        Vector2 backPos;
        Texture2D backTex;
        Color backColor = new Color(255, 255, 255, 100);

        Button backButton, baseButton, guyButton, ugButton; // batteries not included.

        public BuyMenu(GraphicsDevice device, SpriteFont font, Texture2D baseTex, Texture2D guyTex)
        {
            this.dev = device;
            backPos = new Vector2(50, 50);
            backTex = Game.emptyTex(Game.screenWidth - 100, Game.screenHeight - 100, Color.DarkViolet, dev);
            backButton = new Button(new Vector2(60, 60), dev, font, "Back", "Resume your game");
            baseButton = new Button(new Vector2(60, 120), dev, font, "LOWL", "Buy a base (" + basePrize.ToString() + ")", true, baseTex, 0.8f);
            guyButton = new Button(new Vector2(baseTex.Width + 70, 120), dev, font, "ROFL", "A guy that shoots with you! (" + guyPrize.ToString() + ")", true, guyTex, 1f);
            ugButton = new Button(new Vector2(60, 120 + baseTex.Width + 20), dev, font, "Upgrade your guys!", "They will fire faster! (" + upgradeGuyPrize.ToString() + ")");
            this.font = font;
        }

        public bool update(int money)
        {
            if (backButton.isClicked()) return true;

            bool buyBase = baseButton.isClicked();
            if (buyBase && money >= basePrize && !hasBoughtBase)
            {
                money -= basePrize;
                this.hasBoughtBase = true;
                baseButton.tooltip = new ToolTip(this.dev, this.font, "Bought base!");
            }
            else if (!buyBase)
            {
                hasBoughtBase = false;
            }

            bool buyGuy = guyButton.isClicked();
            if (buyGuy && money >= guyPrize && !hasBoughtGuy)
            {
                money -= guyPrize;
                this.hasBoughtGuy = true;
                guyButton.tooltip = new ToolTip(this.dev, this.font, "Bought a awesome guy!");
            }
            else if (!buyGuy)
            {
                hasBoughtGuy = false;
            }

            bool buyUpGuy = ugButton.isClicked();
            if (buyUpGuy && money >= upgradeGuyPrize && !hasBoughtUpGuy)
            {
                money -= upgradeGuyPrize;
                this.hasBoughtUpGuy = true;
                ugButton.tooltip = new ToolTip(this.dev, this.font, "Upgraded your guy!");
            }
            else if (!buyUpGuy)
            {
                hasBoughtUpGuy = false;
            }

            this.money = money;
            return false;
        }

        public void draw(SpriteBatch sb)
        {
            sb.Draw(backTex, backPos, backColor);

            //buttons DRAW IN REVERSE ORDER
            backButton.draw(sb);

            ugButton.draw(sb);
            guyButton.draw(sb);
            baseButton.draw(sb);
        }
    }
}
