﻿using System;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Graphics;

namespace LD28_OneWall
{
    class Button
    {
        public ToolTip tooltip;
        public Vector2 pos;
        public Vector2 textPos;
        public Texture2D tex;
        public Texture2D showTex;
        public Vector2 texPos;
        public Rectangle bounds;
        public SpriteFont font;
        public GraphicsDevice device;
        public Color color = Color.Red;
        public bool showToolTip = true;
        public float scale;
        public string text;
        public string ttText;

        public Button(Vector2 position, GraphicsDevice dev, SpriteFont font, string text, string tooltipText, bool showTT = true, Texture2D tex = null, float scale = 1.0f)
        {
            this.pos = position;
            this.device = dev;
            if (tex == null)
            {
                this.textPos = new Vector2(position.X + 11, position.Y + 3);
                this.font = font;
                this.text = text;
                this.tex = Game.emptyTex(text.Length * 15, 30, Color.White, dev);
            }
            else
            {
                this.showTex = tex;
                this.tex = Game.emptyTex((int)((showTex.Width) * scale) + 10, (int)((showTex.Height) * scale) + 10, Color.White, dev);
                this.texPos = new Vector2(pos.X + 5, pos.Y + 5);
                this.scale = scale;
            }
            
            
            this.bounds = new Rectangle((int)pos.X, (int)pos.Y, this.tex.Width, this.tex.Height);

            this.showToolTip = showTT;
            if (showTT)
            {
                this.ttText = tooltipText;
                this.tooltip = new ToolTip(dev, font, ttText);
            }
        }


        // CHECK IF CLICKED YA KNOW
        public bool isClicked()
        {
            MouseState mouse = Mouse.GetState();
            Rectangle mouseBounds = new Rectangle(mouse.X, mouse.Y, 1, 1);
            if (mouseBounds.Intersects(bounds))
            {
                if (showToolTip)
                {
                    tooltip.display = true;
                    tooltip.update();
                }
                color = new Color(255, 0, 0, 100);
                if (mouse.LeftButton == ButtonState.Pressed)
                {
                    color = new Color(0, 255, 255, 100);
                    return true;
                }
            }
            else
            {
                if(showToolTip) tooltip.display = false;
                color = Color.Red;
            }
            return false;
        }

        public void draw(SpriteBatch sb)
        {
            sb.Draw(tex, pos, color);
            if (showTex != null) sb.Draw(showTex, texPos, null, Color.White, 0.0f, Vector2.Zero, scale, SpriteEffects.None, 1);
            if (text != null) sb.DrawString(font, text, textPos, Color.Black);
            if (showToolTip) tooltip.draw(sb);
        }
    }

    class ToolTip
    {
        public bool display = false; // CHANE HERE
        public Vector2 pos;
        public Vector2 textPos;
        public Texture2D tex;
        public SpriteFont font;
        public GraphicsDevice device;
        public Color color = Color.Red;
        public string text;

        public ToolTip(GraphicsDevice dev, SpriteFont font, string text)
        {
            this.font = font;
            this.text = text;
            this.device = dev;
            this.tex = Game.emptyTex((text.Length * 14) + 5, 30, Color.White, dev);
        }

        public void update()
        {
            if (display)
            {
                MouseState mouse = Mouse.GetState();
                Vector2 mousePos = new Vector2(mouse.X, mouse.Y);
                this.pos = mousePos;
                this.textPos = new Vector2(pos.X + 11, pos.Y + 3);
            }
        }

        public void draw(SpriteBatch sb)
        {
            if (display)
            {
                sb.Draw(tex, pos, color);
                sb.DrawString(font, text, textPos, Color.Black);
            }
        }
    }
}
