﻿using System;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace LD28_OneWall
{
    public class Bullet
    {
        public int speed = 12;
        public int damage = 10;
        public bool stopDoingThatYouMoran = false;
        public bool stop = false;
        public bool wonderFull = false;
        Texture2D tex;
        Vector2 pos;
        Vector2 targetPos;
        Vector2 difference;
        public Thing[] targets;

        public Bullet(Vector2 position, Vector2 targetPosition, Texture2D texture, Thing[] enemys = null)
        {
            this.pos = position;
            this.tex = texture;
            this.targetPos = targetPosition;
            this.targets = enemys;
        }

        public void update(GameTime gt)
        {
            if (!stopDoingThatYouMoran)
            {
                difference = targetPos - pos;
                difference.Normalize();
                stopDoingThatYouMoran = true;
            }

            // THE INCREDIBLE SPAGHETTI CODE OF SATAN
            if (!stop)
            {
                for (int i = 0; i < speed; i++)
                {
                    pos += difference;

                    if (targets != null)
                    {
                        int target = Game.isHit(targets, pos, tex.Width, tex.Height);
                        if (target >= 0)
                        {
                            Enemy e = (Enemy)targets[target];
                            e.doDamage(damage);
                            targets[target] = e;
                            stop = true;
                            break;
                        }
                    }

                    if (pos.X >= Game.screenWidth + tex.Width || pos.X <= 0 - tex.Width || pos.Y >= Game.screenHeight + tex.Height || pos.Y <= 0 - tex.Width)
                    {
                        stop = true;
                        break;
                    }
                }
            }

        }

        public void draw(SpriteBatch sb)
        {
            if (!wonderFull) sb.Draw(tex, pos, Color.White);
            else
            {
                Random wonderFullRandom = new Random(Guid.NewGuid().GetHashCode());
                sb.Draw(tex, pos, new Color(wonderFullRandom.Next(0, 255), wonderFullRandom.Next(0, 255), wonderFullRandom.Next(0, 255), wonderFullRandom.Next(200, 255)));
            }
            //sb.Draw(tex, pos, Color.White);
        }
    }
}
